/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#include <sys/types.h>
#include <sys/socket.h>

/* In both cases, buf is at least len long.  We can receive no more
   than len-1 from the socket so that we can still guarantee to find
   somewhere to put \0. */

int NSrecv(int s, char *buf, int len, int flags) {
  int rv;

  rv = recv(s, buf, len-1, flags);
  if (rv >= 0) {
    buf[rv] = '\0';
  } else {
    buf[0] = '\0';
  }

  return rv;
}

int NSrecvfrom(int s, char *buf, int len, int flags, 
	       struct sockaddr *from, socklen_t *fromlen) {
  int rv;
  
  rv = recvfrom(s, buf, len-1, flags, from, fromlen);
  if (rv >= 0) {
    buf[rv] = '\0';
  } else {
    buf[0] = '\0';
  }
  
  return rv;
}
