/* 
   This file is part of Practical Distributed Processing
   Copyright (C) 2006-2007 Phillip J. Brooke and Richard F. Paige
*/

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

int sum; 
void *thread_control(void *param); 

int main(int argc, char *argv[])
{
  pthread_t threadid; 
  pthread_attr_t attr;
  if (argc != 2) {
    fprintf(stderr, "usage: pthread <integer constant>\n");
    exit(EXIT_FAILURE);
  }

  /* Check argument is positive */
  if (atoi(argv[1]) < 0) {
    fprintf(stderr,"%d must be > 0\n", atoi(argv[1]));
    exit(EXIT_FAILURE);
  }

  /* Get the default attributes */
  pthread_attr_init(&attr);
  /* Create a new thread */
  pthread_create(&threadid, &attr, thread_control, argv[1]);
  /* Wait for the new thread to terminate */
  pthread_join(threadid,NULL);
  printf("sum = %d\n", sum);
  exit(EXIT_SUCCESS);
}

void *thread_control(void *param)
{
  int upper = atoi(param);
  int i;
  sum=0;
  if (upper > 0) {
    for (i = 1; i <= upper; i++)
      sum += (i*i);
  }
  pthread_exit(0);
  return 0; /* Never reach this line. */
}
